package com.androidbook.simpledrawing;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.os.Bundle;
import android.view.View;

public class DrawCustomFontActivity extends DrawingActivity {

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		setContentView(new ViewWithChessBoardFont(this));
	}

	 private static class ViewWithChessBoardFont extends View {
	        private Paint    mPaint = new Paint(Paint.ANTI_ALIAS_FLAG);
	        private Typeface mType;
	        private float textSize = 32;
	        private float xStart = 7;
	        private float yStart = 75;
	        
	        public ViewWithChessBoardFont(Context context) {
	            super(context);
	            mPaint.setTextSize(textSize);
	        }
	        
	        @Override protected void onDraw(Canvas canvas) {
	            canvas.drawColor(Color.WHITE);
	            
	            // Ta czcionka jest chroniona prawami autorskimi, lecz można z niej korzystać bezpłatnie. 
	            // My skontaktowaliśmy się z jej twórcą pocztą elektroniczną. 
	            mType = Typeface.createFromAsset(getContext().getAssets(),"fonts/chess1.ttf");
	            mPaint.setTypeface(mType);
	            mPaint.setColor(Color.BLACK);
	            
	            // Rysujemy szachownicę.
	            canvas.drawText("5111111116", xStart, yStart, mPaint);
	            canvas.drawText("3RMBWKVNT2", xStart, (yStart+(textSize*1)), mPaint); 
	            canvas.drawText("3OPOPOPOP2", xStart, (yStart+(textSize*2)), mPaint); 
	            canvas.drawText("3 / / / /2", xStart, (yStart+(textSize*3)), mPaint); 
	            canvas.drawText("3/ / / / 2", xStart, (yStart+(textSize*4)), mPaint); 
	            canvas.drawText("3 / / / /2", xStart, (yStart+(textSize*5)), mPaint); 
	            canvas.drawText("3/ / / / 2", xStart, (yStart+(textSize*6)), mPaint); 
	            canvas.drawText("3popopopo2", xStart, (yStart+(textSize*7)), mPaint); 
	            canvas.drawText("3tnvqlbmr2", xStart, (yStart+(textSize*8)), mPaint); 
	            canvas.drawText("7444444448", xStart, (yStart+(textSize*9)), mPaint); 
	        }
	    }
}
